#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = gcc
CXX                 = g++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /usr/local
exec_prefix         = ${prefix}
ARCH                = x86_64-pc-linux-gnu
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}/grass84

GRASS_HOME          = /home/neteler/src/releasebranch_8_4
RUN_GISBASE         = /home/neteler/src/releasebranch_8_4/dist.x86_64-pc-linux-gnu

GRASS_VERSION_MAJOR = 8
GRASS_VERSION_MINOR = 4
GRASS_VERSION_RELEASE = 3dev
GRASS_VERSION_DATE  = 2025
GRASS_VERSION_GIT   = 0b62bc23d8

STRIPFLAG           = 
LD_SEARCH_FLAGS     = -Wl,-rpath-link,${LIB_RUNTIME_DIR} -Wl,-rpath,${INST_DIR}/lib
LD_LIBRARY_PATH_VAR = LD_LIBRARY_PATH

#generate static (ST) or shared (SH)
GRASS_LIBRARY_TYPE  = shlib

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = gcc -shared
SHLIB_LDX           = g++ -shared
SHLIB_LDFLAGS       = -Wl,-soname,$(notdir $@)
SHLIB_CFLAGS        = -fPIC
SHLIB_SUFFIX        = .so
EXE                 = 

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            =  
CFLAGS              = -Werror-implicit-function-declaration -fno-common 
CXXFLAGS            = -g -O2
INCLUDE_DIRS        = 
LINK_FLAGS          = -s -Wl,--export-dynamic

DLLIB               = -ldl
XCFLAGS             = 
XLIBPATH            = 
XLIB                =  -lSM -lICE -lX11
XEXTRALIBS          = 
USE_X11             = 1

MATHLIB             = -lm
ICONVLIB            = 
INTLLIB             = 
SOCKLIB             = 

#ZLIB:
ZLIB                =  -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#BZIP2:
BZIP2LIB            = 
BZIP2INCPATH        = 
BZIP2LIBPATH        = 

#ZSTD:
ZSTDLIB             =  -lzstd 
ZSTDINCPATH         = 
ZSTDLIBPATH         = 

DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         = 
HISTORYLIB          = 

#PostgreSQL:
PQINCPATH           =  -I/usr/include/postgresql
PQLIBPATH           = 
PQLIB               =  -lpq 
USE_POSTGRES        = 1

#MySQL:
MYSQLINCPATH        = 
MYSQLLIBPATH        = 
MYSQLLIB            = 
MYSQLDLIB           = 

#SQLite:
SQLITEINCPATH       = 
SQLITELIBPATH       = 
SQLITELIB           =  -lsqlite3 

#ODBC:
ODBCINC             = 
ODBCLIB             =  -lodbc 

#Image formats:
PNGINC              = -I/usr/include/libpng16
PNGLIB              = -lpng16 -lm -lz -lm
USE_PNG             = 1

TIFFINCPATH         = 
TIFFLIBPATH         = 
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLLIB           =   -lGL 
OPENGLULIB          =   -lGLU 
OPENGL_X11          = 1
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 
USE_OPENGL          = 1

#FFTW:
FFTWINC             = 
FFTWLIB             =  -lfftw3 -lm

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = -lblas
BLASINC             = 
LAPACKLIB           =  -llapack 
LAPACKINC           = 

#LIBSVM
LIBSVM_LIB          =  -lsvm 
LIBSVM_INC          = 
USE_LIBSVM          = 1

#GDAL/OGR
GDALLIBS            = -L/usr/lib -lgdal
GDALCFLAGS          = -I/usr/include/gdal
USE_GDAL            = 1
USE_OGR             = 1

#NetCDF
NETCDFLIBS          = -L/usr/lib/x86_64-linux-gnu -L/usr/lib/x86_64-linux-gnu/hdf5/serial -lnetcdf
NETCDFCFLAGS        = -I/usr/include -I/usr/include/hdf5/serial
USE_NETCDF          = 1

#LAS LiDAR through libLAS
LASLIBS             = 
LASCFLAGS           = 
LASINC              = 
USE_LIBLAS          = 

#LAS LiDAR through PDAL
PDALLIBS             = -lpdalcpp -lgdal -lxml2
PDALINC              = -I/usr/include/pdal -I/usr/include/libxml2 -I/usr/include/gdal
USE_PDAL             = 1

#GEOS
GEOSLIBS            = -L/usr/lib/x86_64-linux-gnu -lgeos_c -lgeos_c 
GEOSCFLAGS          = -I/usr/include
USE_GEOS            = 1

#FreeType:
FTINC               = -I/usr/include/freetype2 -I/usr/include/libpng16 -I/usr/include/freetype2
FTLIB               = -lfreetype -lfreetype 

#PROJ.4:
PROJINC             = 
PROJLIB             =  -lproj 
PROJSHARE           = /usr/share/proj

#OPENDWG:
OPENDWGINCPATH      = 
OPENDWGLIBPATH      = 
OPENDWGLIB          = 
USE_OPENDWG         = 

#cairo
CAIROINC                  = -I/usr/include/cairo -I/usr/include/glib-2.0 -I/usr/lib/x86_64-linux-gnu/glib-2.0/include -I/usr/include/pixman-1 -I/usr/include/uuid -I/usr/include/freetype2 -I/usr/include/libpng16
CAIROLIB                  = -lz -lfontconfig -lfreetype -lcairo -lXext -lXrender -lX11 -lfontconfig 
USE_CAIRO                 = 1
CAIRO_HAS_XRENDER         = 1
CAIRO_HAS_XRENDER_SURFACE = 1

#Python
PYTHON              = python3

#regex
REGEXINCPATH        = 
REGEXLIBPATH        = 
REGEXLIB            =  
USE_REGEX           = 1

#pthreads
PTHREADINCPATH      = 
PTHREADLIBPATH      = 
PTHREADLIB          = 
USE_PTHREAD         = 

#OpenMP
OPENMP_INCPATH      = 
OPENMP_LIBPATH      = 
OPENMP_LIB          = 
OPENMP_CFLAGS       = 
USE_OPENMP          = 

#OpenCL
OCLINCPATH          = 
OCLLIBPATH          = 
OCLLIB              = 
USE_OPENCL          = 

#i18N
HAVE_NLS            = 1

#Large File Support (LFS)
USE_LARGEFILES      = 1
LFS_CFLAGS          = 

#BSD sockets
HAVE_SOCKET         = 1

MINGW		    = 
WINDRES		    = 
MACOSX_APP	    = 
MACOSX_ARCHS        = 
MACOSX_SDK          = 

# Cross compilation
CROSS_COMPILING     = 
