## DESCRIPTION

*i.emissivity* calculates the emissivity in the longwave radiation
spectrum, according to the semi-empirical equation related to NDVI by
Caselles et al. (1997), valid in the NDVI range of 0.16 to 0.74
(Bastiaanssen, 1995).

Caselles et al. (1997) give reference (in Table 3 and Figure 2) to both
the NDVI range used (0.15 - 0.71) and the corresponding emissivity range
used (0.97 - 0.99).

The emissivity is the efficiency of longwave energy returning to the
atmosphere from the skin surface. The skin surface receives heat from
the thermal infrared radiation of the Sun, through atmospheric
interaction. A part is returned to the atmosphere fastly, and another
part is kept in the surface skin to be returned later. In more
scientific terms, the grey body radiation is equal to the black body
radiation times the emissivity.

## REFERENCES

- Bastiaanssen, W.G.M., 1995. Estimation of Land surface parameters by
  remote sensing under clear-sky conditions. PhD thesis, Wageningen
  University, Wageningen, The Netherlands.
  ([PDF](https://edepot.wur.nl/206553))
- Caselles, V., C. Coll, and E. Valor, 1997. Land surface emissivity and
  temperature determination in the whole HAPEX-Sahel area from AVHRR
  data. International Journal of Remote Sensing 18(5):1009-1027.
- Rubio, E., V. Caselles, and C. Badenas, 1997. Emissivity measurements
  of several soils and vegetation types in the 8-14 µm wave band:
  Analysis of two field methods. Remote Sensing of Environment 59(3):
  490-521.

## SEE ALSO

*[i.eb.netrad](i.eb.netrad.md)*

## AUTHOR

Yann Chemin, GRASS Development Team
