#include <unistd.h>
#include <string.h>
#include "global.h"

int get_target(char *group)
{
    char location[GMAPSET_MAX];
    char mapset[GMAPSET_MAX];
    char buf[1024];
    int stat;

    if (!I_get_target(group, location, mapset)) {
        snprintf(buf, sizeof(buf),
                 _("Target information for group <%s> missing"), group);
        goto error;
    }

    snprintf(buf, sizeof(buf), "%s/%s", G_gisdbase(), location);
    if (access(buf, 0) != 0) {
        snprintf(buf, sizeof(buf),
                 _("Target project (location) <%s> not found"), location);
        goto error;
    }
    select_target_env();
    G_setenv_nogisrc("LOCATION_NAME", location);
    stat = G_mapset_permissions(mapset);
    if (stat > 0) {
        G_setenv_nogisrc("MAPSET", mapset);
        G_get_window(&target_window);
        select_current_env();
        return 1;
    }
    snprintf(buf, sizeof(buf),
             _("Mapset <%s> in target project (location) <%s> - "), mapset,
             location);
    (void)G_strlcat(buf, stat == 0 ? _("permission denied") : _("not found"),
                    sizeof(buf));
error:
    (void)G_strlcat(buf, "\n", sizeof(buf));
    (void)G_strlcat(buf, _("Please run i.target for group "), sizeof(buf));
    if (G_strlcat(buf, group, sizeof(buf)) >= sizeof(buf))
        G_fatal_error(_("Internal error: error message too long"));
    G_fatal_error("%s", buf);
    return 1; /* never reached */
}
