## DESCRIPTION

*i.signatures* module allows managing signature files:

- "sig" – generated by [i.gensig](i.gensig.md) for
  [i.maxlik](i.maxlik.md)
- "sigset" – generated by [i.gensigset](i.gensigset.md) for
  [i.smap](i.smap.md)
- "libsvm" - generated internally by [i.svm.train](i.svm.train.md) and used by
  [i.svm.predict](i.svm.predict.md) for classification.
The module can perform multiple actions per run. The order of execution
is "copy", "remove", "rename". When the print flag is specified without
specifying any type of signature files, it would print all signatures
grouped by type.

## NOTES

By default the module will list signature files from all mapsets in the
current search path. It is possible to limit listing only to a single
mapset by providing the "mapset" option. The mapset can be also not
listed in the current search path.  
Actions "remove" and "rename" operate only on the current mapset
(although accept fully qualified names). The "copy" action will accept a
signature file name from any mapset as its first argument (source file
to copy).

## EXAMPLES

Print names of all signature files:

```sh
i.signatures -p
```

Print only signature files of certain type as a JSON:

```sh
i.signatures -p type=sigset format=json
```

Delete signature file called "foo" of type "sig" (i.gensig / i.maxlik).

```sh
i.signatures remove=foo type=sig
```

Copy signature file "bar" from mapset "baz" to current mapset

```sh
i.signatures copy=bar@baz,best_version type=sigset
```

## SEE ALSO

*[i.gensig](i.gensig.md) [i.gensigset](i.gensigset.md) [i.svm.predict](i.svm.predict.md)*

## AUTHOR

Maris Nartiss
