## DESCRIPTION

*r3.colors.out* allows the user to export the color table for a 3D raster
map to a file which is suitable as input to *[r3.colors](r3.colors.md)*.

Alternatively, the color rules can be exported as a JSON format
with **format=json**, to use them in other software.
The color format in JSON can be modified using the **color_format** parameter,
which includes the following options:

- hex: #00BFBF
- rgb: rgb(0, 191, 191)
- hsv: hsv(180, 100, 74)
- triplet: 0:191:191

## EXAMPLES

=== "Command line"

    ```sh
    r3.mapcalc "random = rand(1, 5)" -s
    r3.colors map=random color=gyr
    r3.colors.out map=random
    ```

    Output:

    ```text
    1 0:255:0
    2.5 255:255:0
    4 255:0:0
    nv 255:255:255
    default 255:255:255
    ```

 === "Python (grass.script)"

    ```python
    import grass.script as gs

    gs.run_command("r3.mapcalc", expression="random = rand(1, 5)", flags="s")
    gs.run_command("r3.colors", map="random", color="gyr")
    colors = gs.parse_command("r3.colors.out", map="random", format="json")
    ```

    The JSON output looks like:

    ```json
    {
        "table": [
            {
                "value": 1,
                "color": "#00FF00"
            },
            {
                "value": 2.5,
                "color": "#FFFF00"
            },
            {
                "value": 4,
                "color": "#FF0000"
            }
        ],
        "nv": "#FFFFFF",
        "default": "#FFFFFF"
    }
    ```

## SEE ALSO

*[r.colors](r.colors.md), [r.colors.out](r.colors.out.md),
[r3.colors](r3.colors.md) [v.colors](v.colors.md),
[v.colors.out](v.colors.out.md)*

## AUTHOR

Glynn Clements
