## DESCRIPTION

*r.colors* allows the user to create and/or modify the color table for a
raster map or several raster maps at once. The raster maps (specified on
the command line by **map** or as **file** using an input file with one
map name per line) must exist in the user's current mapset search path.

The **raster** option allows user to specify a raster map *name* from
which to copy the color map.

The **raster_3d** option allows user to specify a 3D raster map *name*
from which to copy the color map.

The **-e** flag equalizes the original raster's color table. It can
preclude the need for *grey.eq* rule, when used as **-e color**=*grey*.
Note however, that this will not yield a color table identical to
*color=grey.eq*, because *grey.eq* scales the fraction by 256 to get a
grey level, while **-e** uses it to interpolate the original color
table. If the original color table is a 0-255 grey scale, **-e** is
effectively scaling the fraction by 255. Different algorithms are used.
**-e** is designed to work with any color table, both the floating point
and the integer raster maps.

The **-g** flag divides the raster's grey value range into 100
logarithmically equal steps (where "step" is a rule with the same grey
level for the start and end points). It can preclude the need for
*grey.log* rule, when used as **-g color**=*grey*. Note however, that
this will not yield a color table identical to *color=grey.log*.
Different algorithms are used. Unlike **color**=*grey.log*, **-g** is
designed to work with both floating point and integer rasters, without
performance issues with large datasets, of any original color table.
Logarithmic scaling doesn't work on negative values. In the case when
the value range includes zero, there's no realistic solution.

The **-e** and **-g** flags are not mutually exclusive.

**offset** and **scale** modify color rules to match the values of a
raster map using the formula *new_value = (old_value + offset) x scale*.
For example, if the units of a raster map are Kelvin x 50, the color
rules *celsius* can be applied with *offset=273.15* and *scale=50*.

If the user specifies the **-w** flag, the current color table file for
the input map will not be overwritten. This means that the color table
is created only if the *map* does not already have a color table. If
this option is not specified, the color table will be created if one
does not exist, or modified if it does.

Color table types *aspect, grey, grey.eq* (histogram-equalized grey
scale), *byg* (blue-yellow-green), *byr* (blue-yellow-red), *gyr*
(green-yellow-red), *rainbow, ramp, ryg* (red-yellow-green), *random*,
and *wave* are pre-defined color tables that *r.colors* knows how to
create without any further input.

In case several input raster maps are provided the range (min, max) of
all maps will be used for color table creation. Hence the created color
table will span from the smallest minimum to the largest maximum value
of all input raster maps and will be applied to all input raster maps.

In general, tables which associate colors with percentages (aspect,
bcyr, byg, byr, elevation, grey, gyr, rainbow, ramp, ryb, ryg and wave)
can be applied to any data, while those which use absolute values
(aspectcolr, curvature, etopo2, evi, ndvi, population, slope, srtm, and
terrain) only make sense for data with certain ranges. One can get a
rough idea of the applicability of a colour table by reading the
corresponding rules file (`$GISBASE/etc/colors/<name>`). For example the
*slope* rule is defined as:

```sh
0  255:255:255
2  255:255:0
5  0:255:0
10 0:255 255
15 0:0:255
30 255:0:255
50 255:0:0
90 0:0:0
```

This is designed for the slope map generated by
*[r.slope.aspect](r.slope.aspect.md)*, where the value is a slope angle
between 0 and 90 degrees.

Similarly, the *aspectcolr* rule:

```sh
0 white
1 yellow
90 green
180 cyan
270 red
360 yellow
```

is designed for the aspect maps produced by
*[r.slope.aspect](r.slope.aspect.md)*, where the value is a heading
between 0 and 360 degrees.

The **rules** color table type will cause *r.colors* to read color table
specifications from standard input (stdin) and will build the color
table accordingly.

Using color table type **rules**, there are two ways to build a color
table: by category values and by "percent" values.

To build a color table by category values' indices, the user should
determine the range of category values in the raster map with which the
color table will be used. Specific category values will then be
associated with specific colors. Note that a color does not have to be
assigned for every valid category value because *r.colors* will
interpolate a color ramp to fill in where color specification rules have
been left out. The format of such a specification is as follows:

```sh
category_value color_name
category_value color_name
.. ..
.. ..
category_value color_name
end
```

Each category value must be valid for the raster map, category values
must be in ascending order and only use standard GRASS color names
(aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta,
orange, purple, red, violet, white, yellow).

Colors can also be specified by color numbers each in the range 0-255.
The format of a category value color table specification using color
numbers instead of color names is as follows:

```sh
category_value red_number:green_number:blue_number
category_value red_number:green_number:blue_number
.. .. .. ..
.. .. .. ..
category_value red_number:green_number:blue_number
end
```

Specifying a color table by "percent" values allows one to treat a color
table as if it were numbered from 0 to 100. The format of a "percent"
value color table specification is the same as for a category value
color specification, except that the category values are replaced by
"percent" values, each from 0-100, in ascending order. The format is as
follows:

```sh
percent_value% color_name
percent_value% color_name
.. ..
.. ..
percent_value% color_name
end
```

Using "percent" value color table specification rules, colors can also
be specified by color numbers each in the range 0-255. The format of a
percent value color table specification using color numbers instead of
color names is as follows:

```sh
percent_value% red_number:green_number:blue_number
percent_value% red_number:green_number:blue_number
.. .. .. ..
.. .. .. ..
percent_value% red_number:green_number:blue_number
end
```

Note that you can also mix these two methods of color table
specification; for example:

```sh
0 black
10% yellow
78 blue
100% 0:255:230
end
```

To set the NULL (no data) color, use the "nv" (null values) parameter:

```sh
0 black
10% yellow
nv white
end
```

To set the color to used for undefined values (beyond the range of the
color rules) use the "default" parameter:

```sh
0 red
1 blue
default grey
end
```

## NOTES

All color tables are stored in `$GISBASE/etc/colors/`. Further
user-defined color tables can also be stored in this directory for
access from the *color* parameter or in a user defined directory. See
also *r.colors.out* for printing color tables easily to the terminal.

The color table assigned to a raster map is stored in
`$GISDBASE/location/mapset/colr/`.

## EXAMPLES

The below example shows how you can specify colors for a three category
map, assigning red to category 1, green to category 2, and blue to
category 3. Start by using a text editor to create the following rules
specification file (save it with the name *rules.file*):

```sh
1 red
2 green
3 blue
end
```

The color table can then by assigned to map *threecats* by the following
GRASS commands (two ways are available):

```sh
# read input from stdin
cat rules.file | r.colors map=threecats rules=-

# read directly from file
r.colors map=threecats rules=rules.file
```

To create a natural looking lookup table (LUT) for true map layer
*elevation*, use the following rules specification file. It will assign
light green shades to the lower elevations (first 20% of the LUT), and
then darker greens (next 15%, and next 20%) and light browns (next 20%)
for middle elevations, and darker browns (next 15%) for higher
elevations, and finally yellow for the highest peaks (last 10% of LUT).

```sh
0% 0:230:0
20% 0:160:0
35% 50:130:0
55% 120:100:30
75% 120:130:40
90% 170:160:50
100% 255:255:100
```

To invert the current rules:

```sh
r.colors map=current_raster -n rast=current_raster
```

## SEE ALSO

*[d.colortable](d.colortable.md), [d.histogram](d.histogram.md),
[d.legend](d.legend.md), [r.colors.out](r.colors.out.md)
[r.colors.stddev](r.colors.stddev.md), [r.support](r.support.md),
[r.univar](r.univar.md), [v.colors](v.colors.md),
[v.colors.out](v.colors.out.md), [r3.colors](r3.colors.md),
[r3.colors.out](r3.colors.out.md)*

See also wiki page [Color
tables](https://grasswiki.osgeo.org/wiki/Color_tables) (from GRASS User
Wiki)

[ColorBrewer](https://colorbrewer2.org) is an online tool designed to
help people select good color schemes for maps and other graphics.

## AUTHORS

Michael Shapiro and David Johnson  
Support for 3D rasters by Soeren Gebbert
