## DESCRIPTION

Module *r3.gradient* computes gradient from a 3D raster map. Results are
three 3D raster maps describing the x, y, z components of the computed
gradient field.

## EXAMPLES

```sh
# create a 3D raster
g.region s=0 n=100 w=0 e=100 b=0 t=100 -p
r3.mapcalc "test_gradient = sqrt(row()*row() +col()*col()+ depth()*depth())"

# compute gradient
r3.gradient input=test_gradient output=grad_x,grad_y,grad_z
```

## SEE ALSO

*[r3.flow](r3.flow.md), [r.flow](r.flow.md)*

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/), developed during GSoC
2014.
