## DESCRIPTION

*r3.in.ascii* allows a user to create a (binary) GRASS 3D raster map
layer from a 3D ASCII raster input file.

The *tiledimension* parameter defines the dimension of the tiles used in
the output file. The format is: XxYxZ

The *nv* parameter specifies which value to convert to NULL-value. If
the specified value is *none*, no conversion is performed. Default is
*none*.

## NOTES

The data is automatically imported into the correct internal coordinate
system, that is visualized in the following picture, independently from
the specified ordering in the ASCII input file:

![The volume coordinate system and tile layout](raster3d_layout.png)  
*The volume coordinate system and tile layout of the imported voxel map*

### Format

The format of the 3D ASCII file:

```sh
version: "grass7"
order:   "nsbt" or "nstb" or "snbt" or "sntb"
north:   floating point
south:   floating point
east:    floating point
west:    floating point
top:     floating point
bottom:  floating point
rows:    integer
cols:    integer
levels:  integer
```

The version and order option have been introduced in GRASS 7 in June
2011. The version option is self explaining. The order option specifies
the row and depth order of the data in the input file. The supported
row/depth ordering is documented in the *r3.out.ascii* manual page. The
order of the data in the input file does not specify the data order in
the generated output 3D raster map which is in any case *north -\>
south, west -\> east, bottom -\> top* order. So dependent on the order
information the data is automatically imported into the correct internal
coordinate system.

The version and order options are not mandatory. In case no version and
order option is specified, the default GRASS 6 ASCII format is assumed.

This header is followed by the cell values in *floating point* format
organized in rows with constant *col* and *level* coordinate. The rows
are organized by constant *level* coordinate. Individual cell values are
separated by *space* or *CR*.

## EXAMPLES

4x3x2 sample. Note in case no specific ordering is specified in the
input file the upper-left (NW) corner of the bottom level comes first.
The according order option is: nsbt for north -\> south, bottom -\> top
ordering. This is identical with *r.in.ascii* for single level data. So
the y coordinate is 0 at the northern edge.

```sh
north: 3.0  
south: 0.0  
east: 4.0  
west: 0.0  
top: 2.0  
bottom: 0.0  
rows: 3  
cols: 4  
levels: 2  
x1,y1,z1 x2,y1,z1 x3,y1,z1 x4,y1,z1
x1,y2,z1 x2,y2,z1 x3,y2,z1 x4,y2,z1
x1,y3,z1 x2,y3,z1 x3,y3,z1 x4,y3,z1
x1,y1,z2 x2,y1,z2 x3,y1,z2 x4,y1,z2
x1,y2,z2 x2,y2,z2 x3,y2,z2 x4,y2,z2
x1,y3,z2 x2,y3,z2 x3,y3,z2 x4,y3,z2
```

Note that unit tests for *r3.in.ascii* are implemented in the
*test.r3.out.ascii.sh* script located in the *r3.out.ascii* directory.

Please also refer to the detailed examples in
[r3.out.ascii](r3.out.ascii.md).

## SEE ALSO

*[r.in.ascii](r.in.ascii.md), [r3.out.ascii](r3.out.ascii.md),
[v.to.rast3](v.to.rast3.md), [g.region](g.region.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka, Sören Gebbert
