## DESCRIPTION

Visualization program which loads the isosurfaces previously calculated
using *r3.mkdspf* and displays them according to commands given at the
prompt. *r3.mkdspf* creates a dspf file from the 3D raster and
*r3.showdspf* uses this dspf file to draw isosurfaces and 3D raster map
to draw planes and everything related (boxes, etc).

Upon initialization of the program, two graphics windows are opened, one
for the color table and the other for data display. The display window
initially contains a red bounding box. Command options are then printed
to the terminal and user is prompted for drawing instructions:

```sh
THE INTERACTIVE OPTIONS ARE:

?, (l #), L, (t #), (T # #), I, +, -
(x #) (y #) (z #) r (X #) (Y #) (Z #)
(B(x,y,z)#), (E(x,y,z)#), S, R, F, C, c, s, b, g, n, p[#], d, D, w, Q, h

 USAGE AND MEANING:

 ?         lists available thresholds
 l index# [index#...]  add threshold to display list
 L         draw current display list
 t index#  reset so only this threshold is displayed
 T index# index#   show thresholds between hi & lo
 I         toggle thresholds INSIDE hi/lo or OUTSIDE hi/lo
 +(+++)    display thresholds with consecutively increasing index#
 -(---)    display thresholds with consecutively decreasing index#

 x int#  absolute rotation around x-axis in degrees(int)
 y int#  absolute rotation around y-axis in degrees(int)
 z int#  absolute rotation around z-axis in degrees(int)
 r       rotate_model
 X int#  scale model in x
 Y int#  scale model in y
 Z int#  scale model in z

 B(x,y,z)int#  begin display along (x,y,z) axis at #
 E(x,y,z)int#  end display along (x,y,z)axis #
 S int#        specular highlight control
 R   resets display along axis to show all data
 F grid3name colortablename load new color file

 C   toggles the clear flag
 c   clears the display (no thresholds)
 s   swaps buffers
 b   toggles draw a box
 g   toggles grid
 n   toggles surface normal direction

 p   draw all walls
 p#  draw a wall: 1-top, 2-bottom, 3-east, 4-west, 5-north, 6-south

 d   draw (implement the option)
 D   draw a solid defined by T(isosurface + parts of walls)

 w   dump image to a file
 Q   QUIT
 h   help

 enter desired manipulations then press return
 >>

```

### Hints

- To navigate around the data, use the *r* command, then place the mouse
  pointer in the graphics window and drag with the left mouse to rotate
  the bounding box. To zoom in and out, drag right or left with the
  middle mouse. When satisfied with the new viewing position, click with
  the right mouse.
- To quickly view a series of isosurfaces, enter a series of *+* or *-*
  characters, i.e. *+++++++*
- Scripts using above commands on separate lines may be directed to
  *r3.showdspf* as standard input. Use the *\#* sign as the first
  character on a line to indicate a comment.

## EXAMPLES

After generating a "dspf" control file with *r3.mkdspf* start
*r3.showdspf*. Display/add the layers using *+*.

List available thresholds with *?*. Use *l* to select isosurfaces
(available number can be adjusted with *r3.mkdspf*) and *L* to
display:  
`l 1 2 3 4 5`  
`L`

To select and display a single threshold (here: 2), use:  
`t 2`

To select and display a range of thresholds (here: 3-5), use:  
`T 3 5`  
`D`

To draw a box, enter  
`p`  
the p# to plot a selected wall (here top wall):  
`p1`

Tp draw a cut-off box, define it's position  
`Ex20`  
`p`  
Here Ex20 defines the x coordinate of the end of the box.

In general - *p* draws a side of a box, *E*, *B*, define where that box
starts or ends, so to make a fence diagram, the user draws sides of a
series of boxes which have their starting (or ending) side shifting by a
given interval. (this way the user can draw even more complex fence
diagrams which have perpendicular fences, by using Ey or By). It is
sufficient to use only *E* or *B* depending whether fence are drawn by
using the end side or front side of a box).

To draw a fence, a sequence like this would be needed  
`Ex10`  
`p5`  
`Ex15`  
`p5`  
`Ex20`  
`p5`  
`Ex25`  
`p5`  
or the same would be  
`Bx10`  
`p6`  
`Bx15`  
`p6`  
`Bx20`  
`p6`

The *p* is needed for the fence diagram, solids and boxes.

## SEE ALSO

*[r3.mkdspf](r3.mkdspf.md)*

## AUTHOR

Bill Brown, <brown@gis.uiuc.edu>
