## DESCRIPTION

*r3.in.xyz* imports sparse XYZ data from an ASCII file into a 3D raster
map (voxels). It does this by running the *r.in.xyz* module multiple
times for different z-ranges and then assembling the slices with
*r.to.rast3*.

See the [r.in.xyz](r.in.xyz.md) help page for general parameter usage
and tips.

The map is created using the rows, columns, and depths set by current
region settings. Be sure to check and adjust these with the *g.region*
module before performing the import.

You may either use the z-value as the data value for the voxel (e.g.
with the 'n' statistic), or alternately scan another column for the data
values to bin into the voxels. This alternate data column can be both
filtered by range and have a scaling factor applied to it.

## NOTES

The 2D and 3D horizontal region resolutions must match. See the EXAMPLES
section below.

Unlike *r.in.xyz*, reading from stdin and z-scaling are not possible.
Filtering by z-range is accomplished by setting the 3D region.

To enable parallel processing support, set the **workers=** option to
match the number of CPUs or CPU-cores available on your system.
Alternatively, the `WORKERS` environment variable can be set to the
number of concurrent processes desired.

Points falling exactly on a vertical bound will belong to the depth band
below them, except for points exactly on the top bound, which will
belong to the top-most slice.

The script is expected to be nearly as efficient as if it was fully
written in C.

## EXAMPLE

Using the Serpent Mound dataset. (see the [GRASS LiDAR wiki
page](https://grasswiki.osgeo.org/wiki/LIDAR))

```sh
  #scan dataset for extent:
  r3.in.xyz -s in=Serpent_Mound_Model_LAS_Data.txt out=dummy \
     x=1 y=2 z=3 separator=space

  # set the 2D and 3D regions:
  g.region n=4323641.57 s=4320942.61 w=289020.90 e=290106.02 res=1 -a
  g.region b=166 t=216 res3=1 tbres=5 -3 -p

  r3.in.xyz in=Serpent_Mound_Model_LAS_Data.txt out=serpent3D \
     method=mean x=1 y=2 z=3 separator=space type=float
```

The same, but aggregate and store backscatter strength from column 5
into voxels in instead of the z-value:

```sh
  r3.in.xyz in=Serpent_Mound_Model_LAS_Data.txt out=serpent3D.bakscat \
     method=mean x=1 y=2 z=3 val=5 separator=space type=float
```

## KNOWN ISSUES

*r.to.rast3* always creates a `double` output map regardless of input.

## SEE ALSO

*[g.region](g.region.md), [r.in.xyz](r.in.xyz.md),
[r.to.rast3](r.to.rast3.md)*

## AUTHOR

Hamish Bowman  
*Dunedin, New Zealand*
