## DESCRIPTION

This command has 2 modes of operation. If no **date** argument is
supplied, then the current timestamp for the 3D raster map is printed.
If a date argument is specified, then the timestamp for the 3D raster
map is set to the specified date(s). See examples below.

See [TIMESTAMP FORMAT](r.timestamp.md#timestamp-format) description for
details.

## NOTES

Strings containing spaces should be quoted. For specifying a range of
time, the two timestamps should be separated by a forward slash. To
remove the timestamp from a 3D raster map, use **date=none**.

## EXAMPLES

Prints the timestamp for the "soils" 3D raster map. If there is no
timestamp for soils, nothing is printed. If there is a timestamp, one or
two lines are printed, depending on if the timestamp for the map
consists of a single date or two dates (ie start and end dates).

```sh
r3.timestamp map=soils
```

Sets the timestamp for "soils" to the single date "15 sep 1987".

```sh
r3.timestamp map=soils date='15 sep 1987'
```

Sets the timestamp for "soils" to have the start date "15 sep 1987" and
the end date "20 feb 1988".

```sh
r3.timestamp map=soils date='15 sep 1987/20 feb 1988'
```

Sets the timestamp for "soils" to have the start date "18 feb 2005
10:30:00" and the end date "20 jul 2007 20:30:00".

```sh
r3.timestamp map=soils date='18 feb 2005 10:30:00/20 jul 2007 20:30:00'
```

Removes the timestamp for the "soils" 3D raster map.

```sh
r3.timestamp map=soils date=none
```

## KNOWN ISSUES

Spaces in the timestamp value are required.

## SEE ALSO

*[r3.info](r3.info.md), [r.timestamp](r.timestamp.md),
[v.timestamp](v.timestamp.md)*

## AUTHORS

Michael Pelizzari  
Lockheed Martin Space Systems  
based on r.timestamp by Michael Shapiro,  
U.S. Army Construction Engineering Research Laboratory
