## DESCRIPTION

*i.maxlik* is a maximum-likelihood discriminant analysis classifier. It
can be used to perform the second step in either an unsupervised or a
supervised image classification.

Either image classification methods are performed in two steps. The
first step in an unsupervised image classification is performed by
*[i.cluster](i.cluster.md)*; the first step in a supervised
classification is executed by the GRASS program
*[g.gui.iclass](g.gui.iclass.md)* (or by providing any other raster map
with already existing training areas). In both cases, the second step in
the image classification procedure is performed by *i.maxlik*.

In an unsupervised classification, the maximum-likelihood classifier
uses the cluster means and covariance matrices from the
*[i.cluster](i.cluster.md)* signature file to determine to which
category (spectral class) each cell in the image has the highest
probability of belonging. In a supervised image classification, the
maximum-likelihood classifier uses the region means and covariance
matrices from the spectral signature file generated by
*[g.gui.iclass](g.gui.iclass.md)*, based on regions (groups of image
pixels) chosen by the user, to determine to which category each cell in
the image has the highest probability of belonging.

In either case, the raster map output by *i.maxlik* is a classified
image in which each cell has been assigned to a spectral class (i.e., a
category). The spectral classes (categories) can be related to specific
land cover types on the ground.

## NOTES

The maximum-likelihood classifier assumes that the spectral signatures
for each class (category) in each band file are normally distributed
(i.e., Gaussian in nature). Algorithms, such as
*[i.cluster](i.cluster.md)*, *[g.gui.iclass](g.gui.iclass.md)*, or
*[i.gensig](i.gensig.md)*, however, can create signatures that are not
valid distributed (more likely with *[g.gui.iclass](g.gui.iclass.md)).*
If this occurs, *i.maxlik* will reject them and display a warning
message.

The signature file (**signaturefile**) contains the cluster and
covariance matrices that were calculated by the GRASS program
*[i.cluster](i.cluster.md)* (or the region means and covariance matrices
generated by *[g.gui.iclass](g.gui.iclass.md)*, if the user runs a
supervised classification). These spectral signatures are what determine
the categories (classes) to which image pixels will be assigned during
the classification process.

The optional name of a **reject** raster map holds the reject threshold
results. This is the result of a chi square test on each discriminant
result at various threshold levels of confidence to determine at what
confidence level each cell classified (categorized). It is the reject
threshold map layer, and contains the index to one calculated confidence
level for each classified cell in the classified image. 16 confidence
intervals are predefined, and the reject map is to be interpreted as 1 =
keep and 16 = reject. One of the possible uses for this map layer is as
a mask, to identify cells in the classified image that have a low
probability (high reject index) of being assigned to the correct class.

## EXAMPLE

Second part of the unsupervised classification of a LANDSAT subscene
(VIZ, NIR, MIR channels) in North Carolina (see
*[i.cluster](i.cluster.md)* manual page for the first part of the
example):

```sh
# using here the signaturefile created by i.cluster
i.maxlik group=lsat7_2002 subgroup=res_30m \
  signaturefile=cluster_lsat2002 \
  output=lsat7_2002_cluster_classes reject=lsat7_2002_cluster_reject

# visually check result
d.mon wx0
d.rast.leg lsat7_2002_cluster_classes
d.rast.leg lsat7_2002_cluster_reject

# see how many pixels were rejected at given levels
r.report lsat7_2002_cluster_reject units=k,p

# optionally, filter out pixels with high level of rejection
# here we remove pixels of at least 90% of rejection probability, i.e. categories 12-16
r.mapcalc "lsat7_2002_cluster_classes_filtered = \
           if(lsat7_2002_cluster_reject <= 12, lsat7_2002_cluster_classes, null())"
```

![RGB composite of input data](i_maxlik_rgb.png)  
*RGB composite of input data*

![Output raster map with pixels classified (10 classes)](i_maxlik_classes.png)  
*Output raster map with pixels classified (10 classes)*

![Output raster map with rejection probability values
(pixel classification confidence levels)](i_maxlik_rejection.png)  
*Output raster map with rejection probability values
(pixel classification confidence levels)*

## SEE ALSO

[Image processing](https://grasswiki.osgeo.org/wiki/Image_processing)
and [Image
classification](https://grasswiki.osgeo.org/wiki/Image_classification)
wiki pages and for historical reference also the GRASS GIS 4 *[Image
Processing
manual](https://grass.osgeo.org/gdp/imagery/grass4_image_processing.pdf)*

*[g.gui.iclass](g.gui.iclass.md), [i.cluster](i.cluster.md),
[i.gensig](i.gensig.md), [i.group](i.group.md),
[i.segment](i.segment.md), [i.smap](i.smap.md), [r.kappa](r.kappa.md)*

## AUTHORS

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory  
Tao Wen, University of Illinois at Urbana-Champaign, Illinois  
Semantic label support: Maris Nartiss, University of Latvia
