## DESCRIPTION

Creates a display file from an existing grid3 file according to
specified threshold levels. The display file is a display list of
polygons that represent isosurfaces of the data volume. If specific
*levels* are given, additional optional parameters are ignored. *Min* or
*max* may be used alone or together to specify a sub-range of the data.
The *step* parameter is given precedence over *tnum*.

### Flags

**-q**  
Suppress progress report & min/max information

**-f**  
Use flat shading rather than gradient

### Parameters

**grid3**  
Name of an existing 3D raster map

**dspf**  
Name of output display file

**levels**  
List of thresholds for isosurfaces

**min**  
Minimum isosurface level

**max**  
Maximum isosurface level

**step**  
Positive increment between isosurface levels

**tnum**  
Number of isosurface threshold levels

Default: 7

## NOTES

Currently the grid3 file must be in the user's mapset since the display
files being created are specific to particular grid3 files and are
contained in directories under them. We should create a mechanism where
users may make display files from others' grid3 files without having to
copy them to their mapset.

## EXAMPLES

With grid3 data (*phdata*) in the range 3-7, we only want to see
isosurface values for the range 4-6. Any of these commands will produce
the same results:  

```sh
r3.mkdspf phdata dspf=iso min=4.0 max=6.0 tnum=5
r3.mkdspf phdata dspf=iso levels=4.0,4.5,5.0,5.5,6.0
r3.mkdspf phdata dspf=iso min=4.0 max=6.0 step=0.5
```

## AUTHOR

Bill Brown, [bbrown@gis.uiuc.edu](mailto:brown@gis.uiuc.edu)
