## DESCRIPTION

Converts one 3D raster map into several 2D raster maps (depends on
depths). If the 2D and 3D region settings are different, the 3D
resolution will be adjusted to the 2D resolution (the depths are not
touched). The user can force *r3.to.rast* to use the 2D resolution of
the input 3D raster map for the output maps, independently from the
current region settings.

![How r3.to.rast works](r3.to.rast.png)  
*How r3.to.rast works*

### Map type conversions

Type of resulting 2D raster maps is determined by the type of the input
3D raster, i.e. 3D raster of type DCELL (double) will result in DCELL 2D
rasters. A specific type for 2D rasters can be requested using the
**type** option.

The **type** option is especially advantageous when the 3D raster map
stores categories (which need to be stored as floating point numbers)
and the 2D raster map should be also categorical, i.e. use integers. The
type is set to `CELL` in this case.

### Modifying the values

The values in the 3D raster map can be modified prior to storing in the
2D raster map. The values can be scaled using the option **multiply**
and a constant value can be added using the option **add**. The new
value is computed using the following equation:

```sh
y = ax + b
```

where *x* is the original value, *a* is the value of **multiply**
option, *b* is the value of **add** option, and *y* is the new value.
When **multiply** is not provided, the value of *a* is 1. When **add**
is not provided, the value of *b* is 0.

## NOTES

Every slice of the 3D raster map is copied to one 2D raster map. The
maps are named like **output***\_slicenumber*. Slices are counted from
bottom to the top, so the bottom slice has number 1.

The number of slices is equal to the number of depths.

To round floating point values to integers when using `type=CELL`, the
**add** option should be set to 0.5.

## SEE ALSO

*[r3.cross.rast](r3.cross.rast.md), [r3.out.vtk](r3.out.vtk.md),
[r3.out.ascii](r3.out.ascii.md), [g.region](g.region.md)*

## AUTHORS

Sören Gebbert  
Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)
