---
title: g.gui.dbmgr
description: wxGUI Attribute Table Manager
index: topic_GUI|GUI
---

## DESCRIPTION

The **Attribute Table Manager** is a *[wxGUI](wxGUI.md)* component to
query, edit, and manage attribute data for vector maps. The attribute
table manager can be launched by clicking on icon
![icon](icons/table.png) in the toolbar. It's also available as a
stand-alone module *g.gui.dbmgr*.

*Attribute table manager* allows you to:

- browse attribute data of vector map, perform SQL select statements;
- modify attribute data, insert new records to attribute table, delete
  existing records;
- highlight selected items in the Map Display Window;
- extract selected items into a new vector map;
- modify attribute table - add, drop, rename columns;
- modify vector map DB connection settings - add, remove or modify
  layers.

![Attribute Table Manager](dbmgr_frame.png)  
*Figure: Simple attribute filtering using Attribute Table Manager.*

### SQL Builder

![Attribute Table Manager and SQL Builder](dbmgr_sql_builder.png)  
*Figure: Attribute filtering using Attribute Table Manager and SQL
Builder.*

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md)*

*[db.columns](db.columns.md), [db.connect](db.connect.md),
[db.describe](db.describe.md), [db.drivers](db.drivers.md),
[db.execute](db.execute.md), [db.select](db.select.md),
[db.tables](db.tables.md)*

*[v.db.addcolumn](v.db.addcolumn.md), [v.db.connect](v.db.connect.md),
[v.db.dropcolumn](v.db.dropcolumn.md),
[v.db.renamecolumn](v.db.renamecolumn.md), [v.what](v.what.md)*

See also
[wiki](https://grasswiki.osgeo.org/wiki/WxGUI_Attribute_Table_Manager)
page including [video
tutorials](https://grasswiki.osgeo.org/wiki/WxGUI_Attribute_Table_Manager#Video_tutorials).

## AUTHORS

Martin Landa, [FBK-irst](https://www.fbk.eu) (2007-2008), Trento, Italy,
and OSGeoREL at the Czech Technical University in Prague, Czech
Republic  
Michael Barton, Arizona State University, USA  
Jachym Cepicky
