## DESCRIPTION

*r3.univar* calculates the univariate statistics for a 3D raster map.
This includes the number of cells counted, minimum and maximum cell
values, range, arithmetic mean, population variance, standard deviation,
coefficient of variation, and sum. Statistics are calculated separately
for every category/zone found in the **zones** input map if given. If
the **-e** extended statistics flag is given the 1st quartile, median,
3rd quartile, and given **percentile** are calculated. If the **-g**
flag is given the results are presented in a format suitable for use in
a shell script. If the **-t** flag is given the results are presented in
tabular format with the given field separator. The table can immediately
be converted to a vector attribute table which can then be linked to a
vector, e.g. the vector that was rasterized to create the **zones**
input raster.

## NOTES

As with most GRASS raster3d modules, *r3.univar* operates on the voxel
array defined by the current 3d region settings, not the original extent
and resolution of the input map. See *[g.region](g.region.md)*.

This module can use large amounts of system memory when the **-e**
extended statistics flag is used with a very large region setting. If
the region is too large the module should exit gracefully with a memory
allocation error. Basic statistics can be calculated using any size
input region.

## EXAMPLE

Computing univariate statistics of a 3D raster with randomly generated
values:

```sh
# define volume
g.region n=10 s=0 w=0 e=10 b=0 t=10 res=1 res3=1 -p3

# generate random map
r3.mapcalc "random_0_1 = rand(0., 1)"

# compute univariate statistics, along with extended statistics
r3.univar -e map=random_0_1 percentile=98
 100%
total null and non-null cells: 1000
total null cells: 0

Of the non-null cells:
----------------------
n: 1000
minimum: 0.00053905
maximum: 0.998322
range: 0.997783
mean: 0.513676
mean of absolute values: 0.513676
standard deviation: 0.289969
variance: 0.0840821
variation coefficient: 56.4498 %
sum: 513.676463040334
1st quartile: 0.257654
median (even number of cells): 0.524313
3rd quartile: 0.763637
98th percentile: 0.982924

# script style output, along with extended statistics
r3.univar -ge map=random_0_1 percentile=98
n=1000
null_cells=0
cells=1000
min=0.000539049520323687
max=0.998322037540536
range=0.997782988020212
mean=0.513676463040334
mean_of_abs=0.513676463040334
stddev=0.289969154194666
variance=0.0840821103843701
coeff_var=56.4497646005434
sum=513.676463040334
first_quartile=0.257654
median=0.524313
third_quartile=0.763637
percentile_98=0.982924
```

## TODO

To be implemented *mode, skewness, kurtosis*.

## SEE ALSO

*[g.region](g.region.md), [r.univar](r.univar.md), [r.mode](r.mode.md),
[r.quantile](r.quantile.md), [r.series](r.series.md),
[r3.stats](r3.stats.md), [r.statistics](r.statistics.md),
[v.rast.stats](v.rast.stats.md), [v.univar](v.univar.md)*

## AUTHORS

Soeren Gebbert  
Code is based on r.univar from  
Hamish Bowman, Otago University, New Zealand  
and Martin Landa  
Zonal loop by Markus Metz
