## DESCRIPTION

*r3.out.ascii* exports a 3D raster map in ASCII format. The *input*
parameter is a valid 3D raster map in the current mapset search path.
The *output* parameter is the name of an ASCII file which will be
written in the current working directory.

If *output* is not specified then standard output (stdout) is used. The
*-h* flag may be used to suppress header information. The module is
sensitive to region settings (set with *g.region*).

The *-c* flag will create GRASS 6 *r3.in.ascii* compatible output.

## NOTES

The default format of the exported ASCII file is equivalent to that
required by *r3.in.ascii*. In particular, files output by *r3.out.ascii*
with header information may be converted back to 3D raster maps with
*r3.in.ascii*.

The format of the ASCII file is:

```sh
version: "grass7"
order:   "nsbt" or "nstb" or "snbt" or "sntb"
north:   floating point
south:   floating point
east:    floating point
west:    floating point
top:     floating point
bottom:  floating point
rows:    integer
cols:    integer
levels:  integer
```

The **version** and **order** options have been introduced in GRASS 7 in
June 2011. The **order** option describes the order of rows and depths
in the output. It is possible to create output of different row order
using the *-r* flag and output of different depths order using the *-d*
flag. The default order is:

```sh
west -> east for columns
north -> south for rows
bottom -> top for depths
```

This header is followed by the cell values in *floating point* format
organized in rows with constant *col* and *level* coordinate. The rows
are organized by constant *level* coordinate. Individual cell values are
separated by *space* or *CR*. Cell values are exported as a series of
horizontal slices in row-major order. The data starts with the upper
left corner (NW) at the bottom of the data set. The values at the
following coordinates are exported:

```sh
(x, y + rows,     z) (x + 1, y + rows,     z) ... (x + cols, y + rows,     z)
(x, y + rows,     z) (x + 1, y + rows - 1, z) ... (x + cols, y + rows - 1, z)
          .                     .                                .
          .                     .                                .
          .                     .                                .
(x, y,   z + depths) (x + 1, y,   z + depths) ... (x + cols, y,   z + depths)
```

This order is compatible with the *r.in.ascii* row -\> column ordering.

Supported orders are:

- **nsbt**: north -\> south and bottom -\> top ordering which is the
  default (no flags)
- **snbt**: south -\> north and bottom -\> top ordering using *-r* flag
- **nstb**: north -\> south and top -\> bottom ordering using *-d* flag
- **sntb**: south -\> north and top -\> bottom ordering using *-rd* flag

The internal storage scheme of 3D raster maps is visualized in the
following picture:

![The coordinate system and tile layout](raster3d_layout.png)  
*The coordinate system and tile layout of a voxel map in GRASS*

One level maps can be imported with *r.in.ascii* (2D raster) using the
default **nsbt** order and removing the header lines "version", "order",
"top", "bottom" and "levels".

## EXAMPLES

We define a small region with 4 columns, 3 rows and 2 depths (4x3x2) and
export it using different ordering definitions:

```sh
g.region res3=1 t=2 b=0 w=0 e=4 s=0 n=3
r3.mapcalc "simple_example = row() + col() + depth()"
```

Default order:

```sh
r3.out.ascii input=simple_example dp=0

version: grass7
order: nsbt
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
3 4 5 6
4 5 6 7
5 6 7 8
4 5 6 7
5 6 7 8
6 7 8 9
```

Inverse row order (-r)

```sh
r3.out.ascii input=simple_example dp=0 -r

version: grass7
order: snbt
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
5 6 7 8
4 5 6 7
3 4 5 6
6 7 8 9
5 6 7 8
4 5 6 7
```

Inverse depth order (-d)

```sh
r3.out.ascii input=simple_example dp=0 -d
version: grass7
order: nstb
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
4 5 6 7
5 6 7 8
6 7 8 9
3 4 5 6
4 5 6 7
5 6 7 8
```

Inverse row and depth order (-rd)

```sh
r3.out.ascii input=simple_example dp=0 -rd

version: grass7
order: sntb
north: 3.000000
south: 0.000000
east: 4.000000
west: 0.000000
top: 2.000000
bottom: 0.000000
rows: 3
cols: 4
levels: 2
6 7 8 9
5 6 7 8
4 5 6 7
5 6 7 8
4 5 6 7
3 4 5 6
```

## SEE ALSO

*[r3.in.ascii](r3.in.ascii.md), [r.out.ascii](r.out.ascii.md),
[g.region](g.region.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka, Sören Gebbert
