## DESCRIPTION

***r3.neighbors*** looks at each voxel in a 3D raster input map layer,
and examines the values assigned to the voxel in a user-defined
"neighborhood" around it. It outputs a new 3D raster map in which each
voxel is assigned a value that is a (user-specified) function of the
values in that voxel's neighborhood. For example, each voxel in the
output map might be assigned a value equal to the average of the values
appearing in its 3 x 3 x 3 voxel "neighborhood" in the input map layer.

### OPTIONS

The user must specify the names of the 3D raster map layers to be used
for **input** and **output**, the **method** used to analyze
neighborhood values (i.e., the neighborhood function or operation to be
performed), and the moving **window** of the neighborhood.

*Neighborhood Operation Methods:* The **neighborhood** operators
determine what new value a center voxel in a neighborhood will have
after examining values inside its neighboring voxels. Each voxel in a 3D
raster map layer becomes the center voxel of a neighborhood as the
neighborhood window moves from voxel to voxel throughout the map layer.
***r3.neighbors*** can perform the following operations:

**average**  
The average value within the neighborhood.

**median**  
The value found half-way through a list of the neighborhood's values,
when these are ranged in numerical order.

**mode**  
The most frequently occurring value in the neighborhood.

**minimum**  
The minimum value within the neighborhood.

**maximum**  
The maximum value within the neighborhood.

**range**  
The range value within the neighborhood.

**stddev**  
The statistical standard deviation of values within the neighborhood.

**sum**  
The sum of values within the neighborhood.

**variance**  
The statistical variance of values within the neighborhood.

**diversity**  
The number of different values within the neighborhood.

**interspersion**  
The percentage of voxels containing values which differ from the values
assigned to the center voxel in the neighborhood, plus 1.

*Neighborhood Size:* The neighborhood moving **window** specifies which
voxel surrounding any given voxel fall into the neighborhood for that
voxel. The **window** must be three comma separated odd integers. The
dimension order is: x,y,z. For example: the parameter window=3,3,3
specifies a moving window (a cube) with 27 voxel.

## NOTES

The ***r3.neighbors*** program works in the current geographic region.
It is recommended, but not required, that the 3D resolution of the
geographic region be the same as that of the 3D raster map layer.

***r3.neighbors*** doesn't propagate NULLs, but computes the aggregation
over the non-NULL voxels in the neighborhood.

## SEE ALSO

*[g.region](g.region.md), [r.neighbors](r.neighbors.md),
[r3.mapcalc](r3.mapcalc.md), [r3.stats](r3.stats.md),
[r3.support](r3.support.md)*

## AUTHOR

Soeren Gebbert
